import java.io.BufferedReader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.logging.Logger;


public class CryptedText {
	
	private static final Logger log = Logger.getLogger( CryptedText.class.getName() );
	
	private char[][] text = new char[20][20];
	
	public void load()
	{
		try {
			Path sourceFile = Paths.get("G:/Eigene Programme/Java/workspace/Cipher/files/crypted_text.txt");	// change this
			BufferedReader brFile = Files.newBufferedReader(sourceFile, Charset.forName("Cp1252"));

			String line;
			int y=0;
			while ((line = brFile.readLine()) != null) {
				for (int x = 0; x < line.length(); x++) {
					this.text[x][y] = line.charAt(x);
				}
				y++;
			}
				
			brFile.close();
		} catch (Exception e) {
			log.severe("An error occured during file handling: " + e);
			e.printStackTrace();
		}
	}
	
	public char[][] getText()
	{
		return this.text;
	}
	
	@Override
	public String toString() {
		String s="\n\nCrypted Text:\n";
		for (int y = 0; y < 20; y++) {
			for (int x = 0; x < 20; x++) {
				s+=this.text[x][y];
			}
			s+="\n";
		}

		return s;
	}

}
