import java.util.ArrayList;
import java.util.concurrent.ThreadLocalRandom;
import java.util.logging.Logger;

public class FleissnerGrille {

	private static final Logger log = Logger.getLogger( FleissnerGrille.class.getName() );
	
	private boolean[][] grilleFilled = new boolean[20][20];
	private boolean[][] grilleMove1 = new boolean[20][20];
	private boolean[][] grilleMove2 = new boolean[20][20];
	private boolean[][] grilleMove3 = new boolean[20][20];
	private boolean[][] grillePossible = new boolean[20][20];
	
	private ArrayList<Coordinate> changes = null;
	
	public FleissnerGrille()
	{
		for (int y = 0; y < 20; y++) {
			for (int x = 0; x < 20; x++) {
				this.grilleFilled[x][y]=false;
				this.grilleMove1[x][y]=false;
				this.grilleMove2[x][y]=false;
				this.grilleMove3[x][y]=false;
				this.grillePossible[x][y]=true;
			}
		}
	}
	
	public void setState(int x, int y, boolean state)
	{
		this.grilleFilled[x][y]=state;
		this.grilleMove1[19-y][x]=state;
		this.grilleMove2[19-x][19-y]=state;
		this.grilleMove3[y][19-x]=state;
		this.grillePossible[x][y]=!state;
		this.grillePossible[19-y][x]=!state;
		this.grillePossible[19-x][19-y]=!state;
		this.grillePossible[y][19-x]=!state;
	}
	
	public boolean isPossible(int x, int y)
	{
		return this.grillePossible[x][y];
	}
	
	public boolean isFilled(int x, int y)
	{
		return this.grilleFilled[x][y];
	}
	
	public void change(int x, int y, int move)
	{
		int newX=0, newY=0;
		switch (move) {
		case 1:
			newX = 19-y;
			newY = x;
			break;
		case 2:
			newX = 19-x;
			newY = 19-y;
			break;
		case 3:
			newX = y;
			newY = 19-x;
			break;
		default:
			break;
		}
		
		this.setState(x, y, false);
		this.setState(newX, newY, true);
	}
	
	public void undoChange(int x, int y, int move)
	{
		int newX=0, newY=0;
		switch (move) {
		case 1:
			newX = 19-y;
			newY = x;
			break;
		case 2:
			newX = 19-x;
			newY = 19-y;
			break;
		case 3:
			newX = y;
			newY = 19-x;
			break;
		default:
			break;
		}
		
		this.setState(newX, newY, false);
		this.setState(x, y, true);
		
	}
	
	public void makeRandomChange(int steps)
	{
		this.changes = new ArrayList<Coordinate>();
		int x, y;
		// remove
		for (int i = 0; i < steps; i++) {
			do {
				x = ThreadLocalRandom.current().nextInt(0, 19 + 1);
				y = ThreadLocalRandom.current().nextInt(0, 19 + 1);
			} 
			while (!this.grilleFilled[x][y]);
			
			this.setState(x, y, false);
			this.changes.add(new Coordinate(x, y, false));
		}

		// add
		for (int i = 0; i < steps; i++) {
			do {
				x = ThreadLocalRandom.current().nextInt(0, 19 + 1);
				y = ThreadLocalRandom.current().nextInt(0, 19 + 1);
			} 
			while (!this.isPossible(x, y));
			
			this.setState(x, y, true);
			this.changes.add(new Coordinate(x, y, true));
		}
	}
	
//	public void undoChange()
//	{
//		if (changes!=null)
//		{
//			for (int i = changes.size()-1; i>=0; i--) {
//				Coordinate change = changes.get(i);
//				this.setState(change.getX(), change.getY(), !change.getState());
//				log.fine("undo: "+change.getX()+"/"+change.getY()+"/"+!change.getState());
//			}
//		}
//		changes = null;
//	}
	
	public String decryptText(char[][] encryptedText)
	{
		String decryptedText = "";
		for (int y = 0; y < 20; y++) {
			for (int x = 0; x < 20; x++) {
				if (this.grilleFilled[x][y])
				{
					decryptedText+=encryptedText[x][y];
				}
			}
		}
		for (int y = 0; y < 20; y++) {
			for (int x = 0; x < 20; x++) {
				if (this.grilleMove1[x][y])
				{
					decryptedText+=encryptedText[x][y];
				}
			}
		}
		for (int y = 0; y < 20; y++) {
			for (int x = 0; x < 20; x++) {
				if (this.grilleMove2[x][y])
				{
					decryptedText+=encryptedText[x][y];
				}
			}
		}
		// attention: last one is used in a different way
		for (int x = 19; x >= 0; x--) {
			for (int y = 0; y < 20; y++) {
				if (this.grilleMove3[x][y])
				{
					decryptedText+=encryptedText[x][y];
				}
			}
		}

		
		return decryptedText;
	}

	@Override
	public String toString() {
		String s="\n\nFilled:\n";
		for (int y = 0; y < 20; y++) {
			for (int x = 0; x < 20; x++) {
				s+= (this.grilleFilled[x][y] ? "X" : "-");
			}
			s+="\n";
		}
		
		s+="\n\n1st Move:\n";
		for (int y = 0; y < 20; y++) {
			for (int x = 0; x < 20; x++) {
				s+= (this.grilleMove1[x][y] ? "X" : "-");
			}
			s+="\n";
		}
		
		s+="\n\nPossible:\n";
		for (int y = 0; y < 20; y++) {
			for (int x = 0; x < 20; x++) {
				s+= (this.grillePossible[x][y] ? "X" : "-");
			}
			s+="\n";
		}
		return s;
	}
	
	
	private class Coordinate
	{
		private int x,y;
		private boolean state;
		
		public Coordinate(int x, int y, boolean state)
		{
			this.x=x;
			this.y=y;
			this.state=state;
		}
		
		public int getX()
		{
			return this.x;
		}
		
		public int getY()
		{
			return this.y;
		}
		
		public boolean getState()
		{
			return this.state;
		}
	}
}
