import java.util.concurrent.ThreadLocalRandom;
import java.util.logging.Logger;

public class FleissnerGrilleSolver {
	
	private static final Logger log = Logger.getLogger( FleissnerGrilleSolver.class.getName() );
	
	public static void main(String[] args) {
		
		CryptedText ct = new CryptedText();
		ct.load();
		log.info(ct+"");
		

		// Build a random grille
		FleissnerGrille fg = new FleissnerGrille();
		
		int x,y;
		for(int i=0; i<100; i++)
		{
			do
			{
				x = ThreadLocalRandom.current().nextInt(0, 19 + 1);
				y = ThreadLocalRandom.current().nextInt(0, 19 + 1);
			}
			while (!fg.isPossible(x, y));
			fg.setState(x, y, true);
		}
		log.info(fg+"");
		
		TextValuator tv = new TextValuator();
		double value = 9999;
		double oldValue = 9999, alltimeLow=9999;
		String decrpytedText;
		int changes=0, iAll=0, lastChangeAll=0;
		int steps=2;
		String bestDecryptedText="";
		
		do{
				iAll++;

				// calculate the best possible solution if only changing one of the cells
				int move, minX=0, minY=0, minMove=0;
				double min = 9999;
				for (x=0; x<=19; x++)
				{
					for (y=0; y<=19; y++)
					{
						if (fg.isFilled(x, y))
						{
							for (move=1; move<=3; move++)
							{
								fg.change(x, y, move);
								decrpytedText = fg.decryptText(ct.getText());
								value = tv.evaluate(decrpytedText);
								fg.undoChange(x, y, move);
								
								if (value < min)
								{
									min = value;
									minX = x;
									minY = y;
									minMove = move;
								}
								
							}
						}
					}
				}
				
				if (min < oldValue)
				{
					// we found a better solution by changing one of the cells
					// go on with this new solution
					fg.change(minX, minY, minMove);
					oldValue = min;
					if (oldValue<alltimeLow) 
					{
						alltimeLow=oldValue;
						lastChangeAll=iAll;
						bestDecryptedText = fg.decryptText(ct.getText());
					}
					changes++;
					
				}
				else
				{
					// we didn't find a better solution so we will do a greater step just to get out of the local minimum
					fg.makeRandomChange(steps);

					if (oldValue<alltimeLow) alltimeLow=oldValue;
					oldValue=9999;
				}
				

				
				log.info("try: " + iAll + " (steps: "+steps+"), changes: "+changes + " (last at: " + lastChangeAll + "), accurateness: " + min + " (best: "+oldValue+", alltime: "+alltimeLow+")");
				log.info("==> "+bestDecryptedText);

		} while (oldValue>3000); // just a low value, algorithm will not terminate...
		
		
		decrpytedText = fg.decryptText(ct.getText());
		value = tv.evaluate(decrpytedText);
		log.info("\n\nGrille:\n"+fg);
		log.info("\n\nDecrpyted text:\n\n"+decrpytedText);
		log.info("Accurateness: " + value);
		 
	}

}
