import java.io.BufferedReader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TextValuator {
	
	private static final Logger log = Logger.getLogger( TextValuator.class.getName() );
	
//	private static ArrayList<NgramFrequency> bigramFrequencies = new ArrayList<NgramFrequency>();
//	private static ArrayList<NgramFrequency> trigramFrequencies = new ArrayList<NgramFrequency>();
	
	private static Hashtable<String, Double> quadgramFrequencies = new Hashtable<String, Double>();
	
	public TextValuator()
	{
//		loadBigramFrequencies();
//		loadTrigramFrequencies();
		loadQuadgramFrequencies();
	}
	
	public double evaluate(String text)
	{	
		double value = 0;
		for (int i=0; i<=396; i++)
		{
			String quadgram = text.substring(i, i+4);
			Double frequency = quadgramFrequencies.get(quadgram);
			if (frequency != null)
			{
				value += frequency;
			}
		}
		
		return -value;
	}
	

	
//	private static int countSubstring(String text, String substring)
//	{
//		Pattern pattern = Pattern.compile(substring);
//		Matcher m = pattern.matcher(text);
//		int count = 0;
//		while (m.find()){
//		    count +=1;
//		}
//		
//		return count;
//	}
	
//	private void loadBigramFrequencies()
//	{
//		try {
//			Path sourceFile = Paths.get("G:/Eigene Programme/Java/workspace/Cipher/files/bigram_frequencies.txt");
//			BufferedReader brFile = Files.newBufferedReader(sourceFile, Charset.forName("Cp1252"));
//
//			String line;
//			while ((line = brFile.readLine()) != null) {
//				StringTokenizer st = new StringTokenizer(line, ":");
//				String bigram = st.nextToken();
//				double frequency = Double.valueOf(st.nextToken());
//				bigramFrequencies.add(new NgramFrequency(bigram, frequency));
//			}
//				
//			brFile.close();
//		} catch (Exception e) {
//			log.severe("An error occured during file handling for bigram frequencies: " + e);
//			e.printStackTrace();
//		}
//	}
	
//	private void loadTrigramFrequencies()
//	{
//		try {
//			Path sourceFile = Paths.get("G:/Eigene Programme/Java/workspace/Cipher/files/trigram_frequencies.txt");
//			BufferedReader brFile = Files.newBufferedReader(sourceFile, Charset.forName("Cp1252"));
//
//			String line;
//			while ((line = brFile.readLine()) != null) {
//				StringTokenizer st = new StringTokenizer(line, ":");
//				String trigram = st.nextToken();
//				double frequency = Double.valueOf(st.nextToken());
//				bigramFrequencies.add(new NgramFrequency(trigram, frequency));
//			}
//				
//			brFile.close();
//		} catch (Exception e) {
//			log.severe("An error occured during file handling for trigram frequencies: " + e);
//			e.printStackTrace();
//		}
//	}
	
	private void loadQuadgramFrequencies()
	{
		try {
			// downloaded this file from http://practicalcryptography.com/media/cryptanalysis/files/english_quadgrams.txt.zip
			Path sourceFile = Paths.get("G:/Eigene Programme/Java/workspace/Cipher/files/english_quadgrams.txt"); // change this
			BufferedReader brFile = Files.newBufferedReader(sourceFile, Charset.forName("Cp1252"));

			String line;
			while ((line = brFile.readLine()) != null) {
				StringTokenizer st = new StringTokenizer(line, " ");
				String quadgram = st.nextToken();
				double frequency = Double.valueOf(st.nextToken());
				frequency = Math.log(frequency/4224127912.0); // change this
				quadgramFrequencies.put(quadgram, Double.valueOf(frequency));
			}
				
			brFile.close();
		} catch (Exception e) {
			log.severe("An error occured during file handling for quadgram frequencies: " + e);
			e.printStackTrace();
		}
	}
	
	
	protected class NgramFrequency
	{
		private String ngram;
		private double frequency;
		
		public NgramFrequency(String ngram, double frequency)
		{
			this.ngram = ngram;
			this.frequency = frequency;
		}
		
		public String getNgram()
		{
			return this.ngram;
		}
		
		public double getFrequency()
		{
			return this.frequency;
		}
	}

}
